% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_rotate}
\alias{mosaic_rotate}
\title{Rotate a mosaic image by specified angles}
\usage{
mosaic_rotate(mosaic, angle, direction = "clockwise")
}
\arguments{
\item{mosaic}{A \code{SpatRaster} object representing the mosaic image.}

\item{angle}{An integer specifying the rotation angle. Must be one of 90,
180, or 270.}

\item{direction}{A string specifying the rotation direction. Must be either
"clockwise" or "anticlockwise".}
}
\value{
A \code{SpatRaster} object with the rotated mosaic image.
}
\description{
This function rotates a mosaic image by 90, 180, or 270 degrees.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
# Convert a mosaic raster to an Image object
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
r90 <- mosaic_rotate(mosaic, 90)
r180 <- mosaic_rotate(mosaic, 180)
r270 <- mosaic_rotate(mosaic, 270)
# Plot all rotations side by side
par(mfrow = c(2, 2))
mosaic_plot(mosaic, main = "Original")
mosaic_plot(r90, main = "90 Degrees")
mosaic_plot(r180, main = "180 Degrees")
mosaic_plot(r270, main = "270 Degrees")
par(mfrow = c(1, 1))

}
}
