% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_lonlat2epsg}
\alias{mosaic_lonlat2epsg}
\title{Project a Mosaic from Lon/Lat to EPSG-based CRS}
\usage{
mosaic_lonlat2epsg(mosaic)
}
\arguments{
\item{mosaic}{A raster object representing the mosaic to be projected. The
mosaic must be in the lon/lat coordinate system.}
}
\value{
A raster object representing the projected mosaic. If the mosaic is
not in the lon/lat coordinate system, a warning is issued.
}
\description{
This function projects a given mosaic from the lon/lat coordinate system to
an EPSG-based CRS determined by the mosaic's extent.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(terra)
library(pliman)

# Create a sample mosaic
mosaic <- rast(nrow=10, ncol=10, xmin=-120, xmax=-60, ymin=30, ymax=60)

# Project the mosaic to the appropriate UTM zone
mosaic_lonlat2epsg(mosaic)
}

}
