% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_file.R
\name{utils_file}
\alias{utils_file}
\alias{file_extension}
\alias{file_name}
\alias{file_dir}
\alias{manipulate_files}
\alias{pliman_indexes}
\alias{pliman_indexes_eq}
\title{Utilities for file manipulation}
\usage{
file_extension(file)

file_name(file)

file_dir(file)

manipulate_files(
  pattern,
  dir = NULL,
  prefix = NULL,
  name = NULL,
  suffix = NULL,
  extension = NULL,
  sep = "",
  save_to = NULL,
  overwrite = FALSE,
  remove_original = FALSE,
  verbose = TRUE
)

pliman_indexes()

pliman_indexes_eq()
}
\arguments{
\item{file}{The file name.}

\item{pattern}{A file name pattern.}

\item{dir}{The working directory containing the files to be manipulated.
Defaults to the current working directory.}

\item{prefix, suffix}{A prefix or suffix to be added in the new file names.
Defaults to \code{NULL} (no prefix or suffix).}

\item{name}{The name of the new files. Defaults to \code{NULL} (original names).
\code{name} can be either a single value or a character vector of the same
length as the number of files manipulated. If one value is informed, a
sequential vector of names will be created as "\code{name}_1", "\code{name}_2", and
so on.}

\item{extension}{The new extension of the file. If not declared (default),
the original extensions will be used.}

\item{sep}{An optional separator. Defaults to \code{""}.}

\item{save_to}{The directory to save the new files. Defaults to the current
working directory. If the file name of a file is not changed, nothing will
occur. If \code{save_to} refers to a subfolder in the current working directory,
the files will be saved to the given folder. In case of the folder doesn't
exist, it will be created. By default, the files will not be overwritten.
Set \code{overwrite = TRUE} to overwrite the files.}

\item{overwrite}{Overwrite the files? Defaults to \code{FALSE}.}

\item{remove_original}{Remove original files after manipulation? defaults to
\code{FALSE}. If \code{TRUE} the files in \code{pattern} will be removed.}

\item{verbose}{If \code{FALSE}, the code is run silently.}
}
\value{
\itemize{
\item \code{file_extension()},  \code{file_name()}, and \code{file_dir()} return a character
string.
\item \code{manipulate_files()} No return value. If \code{verbose == TRUE}, a message is
printed indicating which operation succeeded (or not) for each of the files
attempted.
}
}
\description{
\itemize{
\item \code{file_extension()} Get the extension of a file.
\item \code{file_name()} Get the name of a file.
\item \code{file_dir()} Get or directory of a file
\item \code{manipulate_files()} Manipulate files in a directory with options to rename
(insert prefix or suffix) and save the new files to the same or other provided
directory.
\item \code{pliman_indexes()} Get the indexes available in pliman.
\item \code{pliman_indexes_eq()} Get the equation of the indexes available
in pliman.
}
}
\examples{
\donttest{
library(pliman)
# get file name, directory and extension
file <- "E:/my_folder/my_subfolder/image1.png"
file_dir(file)
file_name(file)
file_extension(file)

# manipulate files
dir <- tempdir()
list.files(dir)
file.create(paste0(dir, "/test.txt"))
list.files(dir)
manipulate_files("test",
                 dir = paste0(dir, "\\\\"),
                prefix = "chang_",
                save_to = paste0(dir, "\\\\"),
                overwrite = TRUE)
list.files(dir)
}
}
