% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_nominal.R
\name{fit.nominal}
\alias{fit.nominal}
\title{Fits the nominal model}
\usage{
fit.nominal(
  Master,
  Phi.mat,
  starting.sv,
  pq.mat,
  tol,
  PersonByItem,
  TraitByTrait,
  ItemByTrait,
  item.by.trait,
  ItemNames,
  LambdaNames,
  NuNames,
  LambdaName,
  NuName,
  PhiNames,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  Maxnphi
)
}
\arguments{
\item{Master}{Master data set in long format}

\item{Phi.mat}{Matrix of starting values of the association parameters}

\item{starting.sv}{Matrix starting values category scale values}

\item{pq.mat}{Array used compute rest scores and total scores}

\item{tol}{Value used to determine convergence of algorithm}

\item{PersonByItem}{Same as inData (rows are response patterns)}

\item{TraitByTrait}{Same as inTraitAdj (trait x trait adjacency)}

\item{ItemByTrait}{Same as inItemTraitAdj (item x trait adjacency)}

\item{item.by.trait}{One dimensional array indicating trait item loads on}

\item{ItemNames}{Names of items in inData (i.e. columns names of
categorical variables)}

\item{LambdaNames}{Lambda names used in the Master and stacked data frames}

\item{NuNames}{Nu names in Master data frame}

\item{LambdaName}{Lambda names in formula for items}

\item{NuName}{Nu names in formula for item regressions}

\item{PhiNames}{Association parameter names for stacked regression}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories per item}

\item{nless}{ncat-1 = number unique lambda and unique nus}

\item{ntraits}{Number of traits}

\item{Maxnphi}{Number of association parametets}
}
\value{
item.log 	 Iteration history of LogLike, lambda, and item parameters

phi.log		 Iteration history of LogLike, lambdas and phi parameters

criterion	 Current value of the convergence statistic

estimates 	 Item x parameter matrix: LogLike, lambda and scale values

Phi.mat	   Estimated conditional correlation matrix

fitem		   Formula for item data

fstack	     Formula for stacked data

item.mnlogit Summaries from final run of mnlogit for item regressions

phi.mnlogit	Summary from final run of mnlogit for stacked regression

mlpl.item	 Max log pseudo-likelihood function from item regressions

mlpl.phi    Maximum of log pseudo-likelihood function from stacked regression

AIC         Akaike information criterion for pseudo-likelihood (smaller is better)

BIC         Bayesian information criterion for pseudo-likelihood (smaller is better)
}
\description{
Function estimates the parameters of LMA models where the category scale
are estimated. The function can be used to estimate the parameters of the
LMA model corresponding the nominal model (for multi-category items) and
the 2 parameter logistic model for dichotomous items. The function sets
up log object(s) and model formula.  In the case of unidimensional models,
the function iterates over item regressions; whereas, for multidimensional
models, the function iterates between the item and phi regressions. This
function is called from 'ple.lma', but can be run outside of 'ple.lma'.
}
\examples{
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
 #--- unidimensional
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)
 s <- set.up(inData, model.type='nominal', inTraitAdj, inItemTraitAdj,
           tol=1e-02)

 n1 <- fit.nominal(s$Master, s$Phi.mat, s$starting.sv, s$pq.mat, s$tol,
       s$PersonByItem, s$TraitByTrait, s$ItemByTrait, s$item.by.trait,
       s$ItemNames, s$LambdaNames,  s$NuNames, s$LambdaName, s$NuName,
       s$PhiNames, s$npersons, s$nitems, s$ncat,s$ nless, s$ntraits,
       s$Maxnphi)

}
