% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lma_summary.R
\name{lma.summary}
\alias{lma.summary}
\title{Produces a summary of results}
\usage{
lma.summary(model.fit)
}
\arguments{
\item{model.fit}{A list object from fitting a model to data}
}
\value{
results   A list with summary information
}
\description{
This utility function creates a summary list with five elements.
The first is a 'report' that contains a summary of characteristics
of the data, the model specification, convergence information,
and fit statistics. The second and third elements complete the
model specification and are the trait adjacency matrix
('TraitByTrait') and  the item x trait adjacency matrix
('ItemByTrait'), respectively. The fouth element, 'estimates',
contains a matrix of item parameters, and the fifth element,
'phi.mat' contains association parameter estimates.
}
\examples{
#--- 3 items from depression, anxiety and stress scales of
#    the daass for 250 cases
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]

#---  log-linear model of independence
 ind <- ple.lma(inData, model.type="independence")
 noquote(lma.summary(ind))

#---   input for uni-dimensional
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

#--- rasch family
 r1 <- ple.lma(inData, model.type="rasch", inItemTraitAdj, inTraitAdj)
 lma.summary(r1)
 #--- Or if specific output is desired
 noquote(lma.summary(r1)$report)
 lma.summary(r1)$TraitByTrait
 lma.summary(r1)$ItemByTrait
 lma.summary(r1)$estimates
 lma.summary(r1)$phi

\donttest{
#--- generalized parial credit model
g1 <- ple.lma(inData, model.type="gpcm", inItemTraitAdj, inTraitAdj, tol=1e-03)
lma.summary(g1)$report
lma.summary(g1)$estimates
lma.summary(g1)$phi

#--- nominal response model
n1 <- ple.lma(inData, model.type="nominal", inItemTraitAdj, inTraitAdj, tol=1e-03)
noquote(lma.summary(n1))
}

}
