% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate_matrix.R
\name{plate_matrix}
\alias{plate_matrix}
\title{plate layout matrix from well IDs}
\usage{
plate_matrix(data, well, plate = 96)
}
\arguments{
\item{data}{vector of data to be placed in matrix}

\item{well}{vector of alphanumeric well IDs. e.g ("A01")}

\item{plate}{number of wells in plate (96 or 384)}
}
\value{
matrix
}
\description{
Given a dataframe of alpha-numeric well IDs e.g ("A01"), and values,
this function will produce a matrix in the form of a plate layout.
}
\examples{
a <- 1:96
wells <- num_to_well(1:96)
plate_matrix(data = a, well = wells)

x <- rnorm(384)
wells <- num_to_well(1:384, plate = 384)
plate_matrix(data = x, well = wells, plate = 384)
}
