% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.plasso.R
\name{plot.cv.plasso}
\alias{plot.cv.plasso}
\title{Plot of cross-validation curves}
\usage{
\method{plot}{cv.plasso}(
  x,
  ...,
  legend_pos = c("bottomright", "bottom", "bottomleft", "left", "topleft", "top",
    "topright", "right", "center"),
  legend_size = 0.5,
  lasso = FALSE
)
}
\arguments{
\item{x}{\code{\link{cv.plasso}} object}

\item{...}{Pass generic \code{\link[base]{plot}} options}

\item{legend_pos}{Legend position. Only considered for joint plot (lass=FALSE).}

\item{legend_size}{Font size of legend}

\item{lasso}{If set as True, only the cross-validation curve for the Lasso model is plotted. Default is False.}
}
\value{
Plots the cross-validation curves for both Lasso and Post-Lasso models (incl. upper and lower standard deviation curves)
for a fitted \code{\link{cv.plasso}} object.
}
\description{
Plot of cross-validation curves.
}
\examples{
# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit cv.plasso to the data
\donttest{p.cv = plasso::cv.plasso(X,y)}
# plot cross-validated MSE curves and number of active coefficients
\donttest{plot(p.cv, legend_pos="bottomleft")}

}
