% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform.R
\name{bioc_version}
\alias{bioc_version}
\alias{bioc_version_map}
\title{Query Bioconductor version information}
\usage{
bioc_version(r_version = getRversion(), forget = FALSE)

bioc_version_map(forget = FALSE)
}
\arguments{
\item{r_version}{The R version number to match.}

\item{forget}{Use \code{TRUE} to avoid caching the Bioconductor mapping.}
}
\value{
\code{bioc_version()} returns a \link{package_version} object.

\code{bioc_version_map()} returns a tibble with columns:
\itemize{
\item \code{bioc_version}: \link{package_version} object, Bioconductor versions.
\item \code{r_version}: \link{package_version} object, the matching R versions.
\item \code{bioc_status}: factor, with levels: \code{out-of-date}, \code{release},
\code{devel}, \code{future}.
}
}
\description{
\code{bioc_version()} queries the matching Bioconductor version for
and R version, defaulting to the current R version
}
\section{Functions}{
\itemize{
\item \code{bioc_version_map}: \code{bioc_version_map()} returns the current mapping between R versions
and Bioconductor versions.
}}

\examples{
\dontshow{if (pkgcache:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bioc_version()
bioc_version("4.0")
bioc_version("4.1")
\dontshow{\}) # examplesIf}
\dontshow{if (pkgcache:::is_online()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bioc_version_map()
\dontshow{\}) # examplesIf}
}
