% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_debug}
\alias{async_debug}
\alias{async_next}
\alias{.an}
\alias{async_step}
\alias{.as}
\alias{async_step_back}
\alias{.asb}
\alias{async_list}
\alias{.al}
\alias{async_tree}
\alias{.at}
\alias{async_wait_for}
\alias{async_where}
\alias{.aw}
\alias{async_debug_shortcuts}
\alias{async_debug_remove_shortcuts}
\title{Async debugging utilities}
\usage{
async_next(el = NULL)

async_step()

async_step_back()

async_list(def = NULL)

async_tree(def = NULL)

async_debug(id, action = TRUE, parent = TRUE)

async_wait_for(id)

async_where(calls = sys.calls(), parents = sys.parents(),
  frm = get_async_frames())

async_debug_shortcuts()

async_debug_remove_shortcuts()
}
\arguments{
\item{el}{Event loop, defaults to the current event loop.}

\item{def}{Deferred value that is used at the root of the DAG. Defaults
to the deferred value corresponding to the result of the async phase.}

\item{id}{Integer scalar, the if of the deferred to debug or to wait for.}

\item{action}{Whether to debug the action callback.}

\item{parent}{Whether to debug the parent callbacks.}

\item{calls}{The calls to print, result of \code{sys.calls()}. Defaults to
the current call stack.}

\item{parents}{The parent frames in the call stack, result of
\code{sys.parents()}. Defaults to the current parents.}

\item{frm}{The async frame to mark. Defaults to the most recent async
frame in the stack.}
}
\description{
Helper function to help with the non-trivial debugging of async code.
}
\details{
Async debugging can be turned on by setting the \code{async_debug} global
option to \code{TRUE}:\preformatted{options(async_debug = TRUE)
}

Setting this value to \code{FALSE} will turn off debugging.

If debugging is on, a \code{\link[=synchronise]{synchronise()}} call will stop at the beginning
of the event loop. No deferred actions of other callbacks have run at
this point. \code{\link[=synchronise]{synchronise()}} stops by calling \code{\link[base:browser]{base::browser()}}. All the
usual \code{\link[=browser]{browser()}} commands (see its manual) can be used here, plus some
extra commands to help async debugging. The extra commands:

\code{async_debug_shortcuts()} adds handy shortcuts to most of the helper
functions. E.g. \code{async_next()} can be invoked as \code{.an} (without the
parens). You only need to run it once per R session. Note that it adds
the shortcuts to the global environment.

\code{async_debug_remove_shortcuts()} removes the shortcuts from the global
environment.

\code{.an} (or \code{async_next()}) runs the next iteration of the event loop.
Note that it does not return until \emph{something} happens in the event loop:
an action or a parent callback is executed, or HTTP or other I/O is
performed. Also note, that a single iteration of the event loop typically
runs multiple action, parent or other callbacks. Once the iteration is
done, the control is returned to the browser.

\code{.as} (or \code{async_step()}) is similar to \code{.an}, but it also starts the
debugging of the action or parent callbacks. I.e. another \code{\link[=browser]{browser()}} is
called at the beginning of \emph{all} callbacks in the next iteration of the
event loop.

\code{.asb} (or \code{async_step_back()}) stops the debugging of the callbacks.
It does not actually exdecutes anything from the event loop, so to go
back to the main async browser, you also need to execute \code{c} (continue).

\code{.al} (or \code{async_list()}) lists all deferred values in the current async
phase. (Only the ones that already exist, some may be created in the
future.) It returns a data frame with columns:
\itemize{
\item \code{id}: The integer id of the deferred value.
\item \code{parents}: Integer vector, the parents of the deferred value.
\item \code{label}: A character label, that is used by \code{async_tree()} to nicely
format information about a deferred value.
\item \code{call}: The call (language object) that created the deferred value.
\item \code{children}: The list of children, an integer vector. A deferred value
can only have one child, unless it is shared.
\item \code{type}: The type of the deferred value. This is an arbitrary label,
specified when the deferred value was created.
\item \code{running}: Whether the deferred value is already running.
\item \code{state}: The state of the deferred value, \code{"pending"}, \code{"fulfilled"} or
\code{"rejected"}. This is typically pending, since resolved deferred
values are removed from the async DAG (in the next event loop
iteration.)
\item \code{cancelled}: Whether the deferred value was cancelled.
\item \code{shared}: Whether the deferred value is shared.
\item \code{filename}: The file name for the source code that created the
deferred value. Only present if this code was parsed with source
references enabled.
\item \code{position}: The start file position, in line:column format, as a
string. Only present if this code was parsed with source references
enabled.
}

\code{.at} (or \code{async_tree()}) prints the DAG of the deferred values.

\code{async_debug()} can be used to debug the action and/or parent callbacks
of the specified deferred value.

\code{async_wait_for()} runs the event loop until the specified deferred
value is resolved (i.e. fulfilled or rejected).

\code{.aw} (or \code{async_where()}) prints a call stack and marks the frame the
corresponds to an action or parent callback.
}
