% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_experiment.R
\name{check_experiment}
\alias{check_experiment}
\title{Checks if the argument is a valid \link{pirouette} experiment.}
\usage{
check_experiment(experiment)
}
\arguments{
\item{experiment}{a \link{pirouette} experiment,
as can be created by \link{create_experiment}}
}
\value{
nothing. Will \link{stop} if not
}
\description{
Will \link{stop} if not.
A valid \link{pirouette} experiment
can be created by \link{create_experiment}.
}
\examples{
if (beautier::is_on_ci()) {

  # Check cleanup by other functions
  beastier::check_empty_beaustier_folders()

  check_experiment(create_test_experiment())
  check_experiment(create_test_gen_experiment())
  if (rappdirs::app_dir()$os != "win") {
    check_experiment(create_test_cand_experiment())
  }
}
}
\seealso{
Use \link{check_experiments} to check if an object
  is a list of experiments
}
\author{
Richèl J.C. Bilderbeek
}
