% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celsius.R
\name{c_k}
\alias{c_k}
\alias{c_f}
\title{Convert to Celsius scale}
\usage{
c_k(x)

c_f(x)
}
\arguments{
\item{x}{temperature in initial scale:
\itemize{
  \item for \code{c_k(x)} - in \href{https://en.wikipedia.org/wiki/Kelvin}{Kelvin}-scale, [\emph{K}]
  \item for \code{c_f(x)} - in \href{https://en.wikipedia.org/wiki/Fahrenheit}{Fahrenheit}-scale, [\emph{°F}]
}
Type: \code{\link{assert_double}}.}
}
\value{
temperature in \emph{Celsius}-scale, [\emph{°C}]. Type: \code{\link{assert_double}}.
}
\description{
Convert temperature measured in
 \href{https://en.wikipedia.org/wiki/Kelvin}{Kelvin}- or
 \href{https://en.wikipedia.org/wiki/Fahrenheit}{Fahrenheit}-scale
 to \href{https://en.wikipedia.org/wiki/Celsius}{Celsius} (\emph{°C}).
}
\examples{
 library(pipenostics)

# Convert from Kelvin to Celsius:
c_k(c(0, 373.15))
# [1]  -273.15  100

# Convert from Fahrenheit to Celsius:
c_f(c(-459.67, 212))
# [1]  -273.15  100

}
\seealso{
\code{\link{k_c}} and \code{\link{f_c}} for converting from Celsius-scale.

Other units: 
\code{\link{f_k}()},
\code{\link{inch_mm}()},
\code{\link{k_c}()},
\code{\link{kgf_mpa}()},
\code{\link{loss_flux}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{units}
