% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-read-write.R
\name{pin_read}
\alias{pin_read}
\alias{pin_write}
\title{Read and write objects to and from a board}
\usage{
pin_read(board, name, version = NULL, hash = NULL, ...)

pin_write(
  board,
  x,
  name = NULL,
  type = NULL,
  title = NULL,
  description = NULL,
  metadata = NULL,
  versioned = NULL,
  tags = NULL,
  ...
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[=pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{hash}{Specify a hash to verify that you get exactly the dataset that
you expect. You can find the hash of an existing pin by looking for
\code{pin_hash} in \code{\link[=pin_meta]{pin_meta()}}.}

\item{...}{Additional arguments passed on to methods for a specific board.}

\item{x}{An object (typically a data frame) to pin.}

\item{type}{File type used to save \code{x} to disk. Must be one of
"csv", "json", "rds", "arrow", or "qs". If not supplied, will use JSON for
bare lists and RDS for everything else. Be aware that CSV and JSON are
plain text formats, while RDS, Arrow, and
\href{https://CRAN.R-project.org/package=qs}{qs} are binary formats.}

\item{title}{A title for the pin; most important for shared boards so that
others can understand what the pin contains. If omitted, a brief
description of the contents will be automatically generated.}

\item{description}{A detailed description of the pin contents.}

\item{metadata}{A list containing additional metadata to store with the pin.
When retrieving the pin, this will be stored in the \code{user} key, to
avoid potential clashes with the metadata that pins itself uses.}

\item{versioned}{Should the pin be versioned? The default, \code{NULL}, will
use the default for \code{board}}

\item{tags}{A character vector of tags for the pin; most important for
discoverability on shared boards.}
}
\value{
\code{pin_read()} returns an R object read from the pin;
\code{pin_write()} returns the fully qualified name of the new pin, invisibly.
}
\description{
Use \code{pin_write()} to pin an object to board, and \code{pin_read()} to retrieve
it.
}
\details{
\code{pin_write()} takes care of the details of serialising an R object to
disk, controlled by the \code{type} argument. See \code{\link[=pin_download]{pin_download()}}/\code{\link[=pin_upload]{pin_upload()}}
if you want to perform the serialisation yourself and work just with files.
}
\examples{
b <- board_temp(versioned = TRUE)

b \%>\% pin_write(1:10, "x", description = "10 numbers")
b

b \%>\% pin_meta("x")
b \%>\% pin_read("x")

# Add a new version
b \%>\% pin_write(2:11, "x")
b \%>\% pin_read("x")

# Retrieve an older version
b \%>\% pin_versions("x")
b \%>\% pin_read("x", version = .Last.value$version[[1]])
# (Normally you'd specify the version with a string, but since the
# version includes the date-time I can't do that in an example)
}
