% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_rsconnect}
\alias{board_register_rsconnect}
\title{Register RStudio Connect Board}
\usage{
board_register_rsconnect(name = "rsconnect", server = NULL,
  account = NULL, key = NULL, output_files = FALSE,
  cache = board_cache_path(), ...)
}
\arguments{
\item{name}{Optional name for this board, defaults to 'rsconnect'.}

\item{server}{Optional address to RStudio Connect server.}

\item{account}{Optional account name to use with RStudio Connect.}

\item{key}{The RStudio Connect API key.}

\item{output_files}{Should the output in an automated report create output files?}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register RStudio Connecet as a board.
}
\examples{
\dontrun{
# the following examples require an RStudio Connect API key

# register from rstudio
board_register_rsconnect()

# register from rstudio with multiple servers
board_register_rsconnect(server = "https://rstudio-connect-server")

# register from rstudio with multiple account
board_register_rsconnect(account = "account-name")

# register automated report for rstudio connect
board_register_rsconnect(key = Sys.getenv("CONNECT_API_KEY"),
                         server = Sys.getenv("CONNECT_SERVER"))
}

}
\seealso{
board_register
}
