% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_datatxt}
\alias{board_register_datatxt}
\title{Register Data TXT Board}
\usage{
board_register_datatxt(name, url, cache = board_cache_path())
}
\arguments{
\item{name}{The name for this board, usually the domain name of the website.}

\item{url}{Path to the \code{data.txt} file or path containing it.}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register as a board a website describing resources with a \code{data.txt} file.
}
\examples{

# register website board using datatxt file
board_register_datatxt(name = "txtexample",
                       url = "https://datatxt.org/data.txt",
                       cache = tempfile())

# find pins
pin_find(board = "txtexample")

}
\seealso{
board_register
}
