% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-PI.r
\name{htsdl}
\alias{htsdl}
\title{Higgins-Thompson-Spiegelhalter prediction interval with the Dersimonian-Laird estimator for \eqn{\hat{\tau}}}
\usage{
htsdl(y, sigma, alpha = 0.05)
}
\arguments{
\item{y}{the effect size estimates vector}

\item{sigma}{the within studies variances vector}

\item{alpha}{the alpha level of the prediction interval}
}
\value{
The average treatment effect estimate \eqn{\hat{\mu}} (\code{muhat}),
the lower and upper prediction limits \eqn{\hat{c}_l} (\code{lpi}) and \eqn{\hat{c}_u} (\code{upi}),
the DL estimator for \eqn{\hat{\tau}} (\code{tau2h}).
}
\description{
Higgins-Thompson-Spiegelhalter prediction interval with the Dersimonian-Laird estimator for \eqn{\hat{\tau}}
}
\examples{
data(sbp, package = "pimeta")
pimeta::htsdl(sbp$y, sbp$sigmak)
# $muhat
# [1] -0.3340597
# $lbpi
# [1] -0.7597777
# $ubpi
# [1] 0.09165839
# $tau2h
# [1] 0.02824971
}
\references{
Higgins, J. P. T, Thompson, S. G., Spiegelhalter, D. J. (2009).
A re-evaluation of random-effects meta-analysis.
\emph{J R Stat Soc Ser A Stat Soc.}
\strong{172}(1): 137-159.
}
