% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pres_atm_kPa}
\alias{pres_atm_kPa}
\alias{pres_atm_frac}
\title{Get mean atmospheric pressure at given altitude in kPa}
\usage{
pres_atm_kPa(altitude_m)

pres_atm_frac(altitude_m)
}
\arguments{
\item{altitude_m}{Altitude above mean sea level in meters}
}
\value{
Pressure in pascals
}
\description{
Get mean atmospheric pressure at given altitude in kPa
}
\section{Functions}{
\itemize{
\item \code{pres_atm_frac}: Get fraction of mean atomspheric pressure at sea level
}}

\examples{
pres_atm_kPa(-430.5) # Dead Sea
pres_atm_kPa(0)
pres_atm_kPa(3440) # Namche Bazaar
pres_atm_kPa(4260) # Dingboche
pres_atm_kPa(5364) # Everest Base Camp
pres_atm_kPa(6000) # Camp 1
pres_atm_kPa(6400) # Camp 2
pres_atm_kPa(7200) # Camp 3
pres_atm_kPa(7950) # Camp 4
pres_atm_kPa(8850) # Everest summit
pres_atm_frac(8850) # fraction of sea level pressure on Everest
}
\references{
Below 51 km: Practical Meteorology by Roland Stull, pg 12. Above 51 km:
\url{http://www.braeunig.us/space/atmmodel.htm} Validation data:
\url{https://www.avs.org/AVS/files/c7/c7edaedb-95b2-438f-adfb-36de54f87b9e.pdf}
}
\seealso{
Other physics: \code{\link{Pa_to_torr}},
  \code{\link{svp_sea_level}}, \code{\link{temp_c_to_k}}
}
\concept{atmospheric pressure}
\concept{physics}
