% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloWeights.R
\name{phyloWeights}
\alias{phyloWeights}
\title{Phylogenetic weights matrix}
\usage{
phyloWeights(tree, dist.phylo = "patristic", method = "lag-norm", mu = 0,
  sigma = 5, dmax = 10, alpha = 1, beta = 1)
}
\arguments{
\item{tree}{a \code{phylo}, \code{phylo4} or \code{phylo4d} object.}

\item{dist.phylo}{a character string specifying the method used to compute phylogenetic distances.
Available distances are "\code{patristic}","\code{nNodes}","\code{Abouheif}" and "\code{sumDD}".
See Details.}

\item{method}{a method to compute phylogenetic weights from phylogenetic distances.
Available methods are "\code{lag-norm}", "\code{clade}", "\code{inverse}" and "\code{exponential}".
See Details.}

\item{mu}{a numeric value giving the mean of the distribution if \code{method} is \code{lag-norm}.
This is a phylogenetic distance.}

\item{sigma}{a numeric value giving the standard deviation
of the distribution if \code{method} is \code{lag-norm}.}

\item{dmax}{the maximum phylogenetic distance to use to delineate clades.}

\item{alpha}{a numeric value giving the exponent to use if \code{method} is \code{inverse}.}

\item{beta}{a numeric value giving the factor to use if \code{method} is \code{exponential}.}
}
\value{
A square matrix of phylogenetic weights whose sums of rows is 1.
}
\description{
This function can be used to compute a phylogenetic weights matrix
with different methods.
}
\details{
Method "\code{inverse}": \deqn{\frac{1}{d^{\alpha}}}{w = 1/d^alpha}

The phylogenetic distance matrix is computed internally
using the function \code{\link[adephylo]{distTips}} from the package \pkg{adephylo}.
See \code{\link[adephylo]{distTips}} for details about the methods.
}
\seealso{
\code{\link[adephylo]{proxTips}} in \pkg{adephylo}.
}
