% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{BNPR}
\alias{BNPR}
\alias{BNPR_PS}
\title{Bayesian nonparametric phylodynamic reconstruction.}
\usage{
BNPR(data, lengthout = 100, pref = FALSE, prec_alpha = 0.01,
  prec_beta = 0.01, beta1_prec = 0.001, fns = NULL, log_fns = TRUE,
  simplify = TRUE, derivative = FALSE, forward = TRUE)

BNPR_PS(data, lengthout = 100, prec_alpha = 0.01, prec_beta = 0.01,
  beta1_prec = 0.001, fns = NULL, log_fns = TRUE, simplify = TRUE,
  derivative = FALSE, forward = TRUE)
}
\arguments{
\item{data}{\code{phylo} object or list containing vectors of coalescent 
times \code{coal_times}, sampling times \code{samp_times}, and number 
sampled per sampling time \code{n_sampled}.}

\item{lengthout}{numeric specifying number of grid points.}

\item{pref}{logical. Should the preferential sampling model be used?}

\item{prec_alpha, prec_beta}{numerics specifying gamma prior for precision 
\eqn{\tau}.}

\item{beta1_prec}{numeric specifying precision for normal prior on 
\eqn{\beta_1}.}

\item{fns}{list containing functions of covariates.}

\item{log_fns}{logical whether or not to to apply a log-transformation to
the output of the functions in \code{fns}.}

\item{simplify}{logical whether to fully bucket all Poisson points.}

\item{derivative}{logical whether to calculate estimates of the 
log-derivative.}

\item{forward}{logical whether to use the finite difference approximations of
the log-derivative as a forward or backward derivative.}
}
\value{
Phylodynamic reconstruction of effective population size at grid 
  points. \code{result} contains the INLA output, \code{data} contains the 
  information passed to INLA, \code{grid} contains the grid end points, 
  \code{x} contains the grid point centers, \code{effpop} contains a vector 
  of the posterior median effective population size estimates, 
  \code{effpop025} and \code{effpop975} contain the 2.5th and 97.5th 
  posterior percentiles, \code{summary} contains a data.frame of the 
  estimates, and \code{derivative} (if \code{derivative = TRUE}) contains a
  data.frame summarizing the log-derivative.
}
\description{
Bayesian nonparametric phylodynamic reconstruction.
}
\section{Functions}{
\itemize{
\item \code{BNPR_PS}: Uses preferential sampling model.
}}
\examples{
data("NY_flu")
if (requireNamespace("INLA", quietly = TRUE)) {
 res = BNPR(NY_flu)
 plot_BNPR(res)
}
}

