% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_models.R
\name{gs_mod_ballberry}
\alias{gs_mod_ballberry}
\alias{gs_mod_leuning}
\alias{gs_mod_opti}
\alias{gs_mod_optifull}
\title{Stomatal conductance models}
\usage{
gs_mod_ballberry(A_net, C_air, RH)

gs_mod_leuning(A_net, C_air, D0, VPD)

gs_mod_opti(g0, g1, VPD, A_net, C_air)

gs_mod_optifull(g0, g1, gk, VPD, A_net, C_air)
}
\arguments{
\item{A_net}{Net CO2 assimilation in umol m-2 s-1}

\item{C_air}{CO2 concentration at the leaf surface in umol mol-1}

\item{RH}{Relative humidity as a proportion}

\item{D0}{Vapor pressure sensitivity of stomata (Leuning 1995)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{g0}{Optimization model intercept term (Medlyn et al. 2011)}

\item{g1}{Optimization model slope term (Medlyn et al. 2011)}

\item{gk}{Optimization model root term (Medlyn et al. 2011)}
}
\value{
gs_mod_ballberry is used for fitting the Ball et al. (1987) model
of stomatal conductance

gs_mod_leuning is used for fitting the Leuning (1995) model
of stomatal conductance

gs_mod_opti fits the optimal stomatal conductance model according to
Medlyn et al. 2011

gs_mod_optifull fits the full optimal stomatal conductance model according
to Medlyn et al. 2011
}
\description{
Stomatal conductance models
}
\references{
Ball JT, Woodrow IE, Berry JA. 1987. A model predicting stomatal
conductance and its contribution to the control of photosynthesis
under different environmental conditions, in Progress in
Photosynthesis Research, Proceedings of the VII International
Congress on Photosynthesis, vol. 4, edited by I. Biggins, pp.
221–224, Martinus Nijhoff, Dordrecht, Netherlands.

Leuning R. 1995. A critical appraisal of a coupled stomatal-
photosynthesis model for C3 plants. Plant Cell Environ 18:339-357

Medlyn BE, Duursma RA, Eamus D, Ellsworth DS, Prentice IC, Barton
CVM, Crous KY, Angelis PD, Freeman M, Wingate L. 2011. Reconciling
the optimal and empirical approaches to modeling stomatal
conductance. Glob Chang Biol 17:2134-2144
}
