% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvc.r
\name{UVC}
\alias{UVC}
\title{Definition of UV-C waveband}
\usage{
UVC(std = "ISO")
}
\arguments{
\item{std}{a character string "CIE", "ISO", "none", or "medical".}
}
\value{
a waveband object wavelength defining a wavelength range.
}
\description{
UV-C according to CIE and ISO standrads: 100--280 nm. UV-c according to
common non-standard practice: 200--280 nm. UV-C according to medical or
dermatological non-standard practice, e.g. Diffey (1991): 200--290 nm.
}
\examples{
UVC()
UVC("CIE")
UVC("ISO")
UVC("none")
UVC("medical")

}
\seealso{
\code{\link{new_waveband}}  \code{\link{waveband}}

Other unweighted wavebands: \code{\link{Blue}},
  \code{\link{Far_red}}, \code{\link{Green}},
  \code{\link{Orange}}, \code{\link{Purple}},
  \code{\link{Red}}, \code{\link{UVA}}, \code{\link{UVB}},
  \code{\link{UV}}, \code{\link{VIS}}, \code{\link{Yellow}}
}

