% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-aster-file.r
\name{read_ASTER_txt}
\alias{read_ASTER_txt}
\title{Read File downloaded from ASTER data base.}
\usage{
read_ASTER_txt(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  npixels = 2048
)
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Ignored.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{npixels}{integer Number of pixels in spectral data.}
}
\value{
A raw_spct object.
}
\description{
Reads and parses the header of a test file as available through the
ASTER reflectance database. The Name field is retrieved and copied to
attribute "what.measured". The header of the file is preserved as a comment.
}
\note{
The header in these files has very little information, so the user
needs to supply the number of pixels in the array as well as the date-time.
The file contains a date in milliseconds but as the Raspberry Pi board
contains no real-time clock, it seems to default to number of milliseconds
since the Pi was switched on.
}
\references{
\url{https://www.r4photobiology.info} \url{https://speclib.jpl.nasa.gov/}
Baldridge, A.; Hook, S.; Grove, C. & Rivera, G. (2009) The ASTER spectral 
library version 2.0. Remote Sensing of Environment. 113, 711-715
}
