% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.data.R
\docType{data}
\name{sun.data}
\alias{sun.data}
\title{Solar spectral irradiance (simulated)}
\format{A \code{data.frame} object with 508 rows and 3 variables}
\description{
A dataset containing the wavelengths at a 1 nm interval and the
  corresponding spectral (energy) irradiance and spectral photon irradiance.
  Values simulated for 22 June 2010, near midday, at Helsinki, under partly
  cloudy conditions. The variables are as follows:
}
\details{
\itemize{ \item w.length (nm), range 293 to 800 nm. \item s.e.irrad
(W m-2 nm-1) \item s.q.irrad (mol m-2 nm-1) }
}
\references{
Lindfors, A.; Heikkilä, A.; Kaurola, J.; Koskela, T. & Lakkala,
K. (2009) Reconstruction of Solar Spectral Surface UV Irradiances Using
Radiative Transfer Simulations. Photochemistry and Photobiology, 85:
1233–1239
}
\seealso{
Other Spectral data examples: \code{\link{A.illuminant.spct}},
  \code{\link{D65.illuminant.spct}},
  \code{\link{black_body.spct}}, \code{\link{ccd.spct}},
  \code{\link{clear.spct}}, \code{\link{clear_body.spct}},
  \code{\link{filter_cps.mspct}},
  \code{\link{green_leaf.spct}},
  \code{\link{photodiode.spct}},
  \code{\link{polyester.spct}},
  \code{\link{sun.daily.data}},
  \code{\link{sun.daily.spct}}, \code{\link{sun.spct}},
  \code{\link{white_body.spct}},
  \code{\link{white_led.cps_spct}},
  \code{\link{white_led.raw_spct}},
  \code{\link{white_led.source_spct}},
  \code{\link{yellow_gel.spct}}
}
\author{
Anders K. Lindfors (data)
}
\keyword{datasets}
