% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciexyz.data.r
\docType{data}
\name{cone_fundamentals10.spct}
\alias{cone_fundamentals10.spct}
\alias{cone_fundamentals10.mspct}
\title{Ten-degree cone fundamentals}
\format{
A chroma_spct object with 440 rows and 4 variables

An object of class \code{response_mspct} (inherits from \code{generic_mspct}, \code{list}) with 3 rows and 1 columns.
}
\usage{
cone_fundamentals10.spct

cone_fundamentals10.mspct
}
\value{
A \code{chroma_spct} object.

A \code{response_mspct} object containing the same data in three
\code{response_spct} objects, one for each of x, y and z.
}
\description{
A dataset containing wavelengths at a 1 nm interval (390 nm to
  830 nm) and the corresponding response values for a 2 degrees target.
  Original data from \url{http://www.cvrl.org/} downloaded on 2014-04-29 The
  variables are as follows:
}
\details{
\itemize{
  \item w.length (nm)
  \item x
  \item y
  \item z }
}
\note{
These data are not from the official CIE on-line distribution but
  are retained for backwards compatibility. It is recommended to download
  the latest version from \url{https://cie.co.at/data-tables}.

The missing data for z in the NIR have been filled with zeros.
}
\examples{
cone_fundamentals10.spct

}
\seealso{
Other Visual response data examples: 
\code{\link{beesxyzCMF.spct}},
\code{\link{ciev10.spct}},
\code{\link{ciev2.spct}},
\code{\link{ciexyzCC10.spct}},
\code{\link{ciexyzCC2.spct}},
\code{\link{ciexyzCMF10.spct}},
\code{\link{ciexyzCMF2.spct}}
}
\author{
CIE
}
\concept{Visual response data examples}
\keyword{datasets}
