% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetic_association.R
\name{getGeneticAssociations}
\alias{getGeneticAssociations}
\title{Perform association tests between phenotype risk scores and genotypes}
\usage{
getGeneticAssociations(
  scores,
  genotypes,
  demos,
  diseaseVariantMap,
  lmFormula,
  modelType = c("genotypic", "additive", "dominant", "recessive"),
  level = 0.95,
  dopar = FALSE
)
}
\arguments{
\item{scores}{A data.table of phenotype risk scores. Must have columns
\code{person_id}, \code{disease_id}, \code{score}.}

\item{genotypes}{A matrix or 'BEDMatrix' object containing genetic data, with
rownames corresponding to \code{person_id}s in \code{demos} and \code{scores}, and
colnames corresponding to \code{variant_id}s in \code{diseaseVariantMap}.}

\item{demos}{A data.table of characteristics for each person in the cohort.
Must have column \code{person_id}.}

\item{diseaseVariantMap}{A data.table indicating which genetic variants to
test for association with phenotype risk scores for which diseases. Must
have columns \code{disease_id} and \code{variant_id}.}

\item{lmFormula}{A formula representing the linear model (excluding the term
for genotype) to use for the association tests. All terms in the formula
must correspond to columns in \code{demos}.}

\item{modelType}{A string indicating how to encode genotype in the model.}

\item{level}{A number indicating the level of the confidence interval.
Default is 0.95.}

\item{dopar}{Logical indicating whether to run calculations in parallel if
a parallel backend is already set up, e.g., using
\code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}. Recommended to minimize runtime.}
}
\value{
A data.table of statistics for the association tests (if a model
fails to converge, NAs will be reported):
\itemize{
\item \code{disease_id}: Disease identifier
\item \code{variant_id}: Variant identifier
\item \code{n_total}: Number of persons with non-missing genotype data for the
given variant.
\item \code{n_wt}: Number of persons homozygous for the wild-type allele.
\item \code{n_het}: Number of persons having one copy of the alternate allele.
\item \code{n_hom}: Number of persons homozygous for the alternate allele.
\item \code{beta}: Coefficient for the association of genotype with score
\item \code{se}: Standard error for \code{beta}
\item \code{pval}: P-value for \code{beta} being non-zero
\item \code{ci_lower}: Lower bound of the confidence interval for \code{beta}
\item \code{ci_upper}: Upper bound of the confidence interval for \code{beta}
}

If \code{modelType} is "genotypic", the data.table will include separate
statistics for heterozygous and homozygous genotypes.
}
\description{
The association test for each disease-variant pair is based on a linear
model, with the phenotype risk score as the dependent variable.
}
\examples{
library('data.table')
library('BEDMatrix')

# map ICD codes to phecodes
phecodeOccurrences = getPhecodeOccurrences(icdSample)

# calculate weights
weights = getWeights(demoSample, phecodeOccurrences)

# OMIM disease IDs for which to calculate phenotype risk scores
diseaseId = 154700

# map diseases to phecodes
diseasePhecodeMap = mapDiseaseToPhecode()

# calculate scores
scores = getScores(weights, diseasePhecodeMap[disease_id == diseaseId])

# map diseases to genetic variants
nvar = 10
diseaseVariantMap = data.table(disease_id = diseaseId, variant_id = paste0('snp', 1:nvar))

# load sample genetic data
npop = 50
genoSample = BEDMatrix(system.file('extdata', 'geno_sample.bed', package = 'phers'))
colnames(genoSample) = paste0('snp', 1:nvar)
rownames(genoSample) = 1:npop

# run genetic association tests
genoStats = getGeneticAssociations(
  scores, genoSample, demoSample, diseaseVariantMap, lmFormula = ~ sex,
  modelType = 'additive')
}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:confint]{stats::confint()}}, \code{\link[=getScores]{getScores()}}
}
