% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/season_mov.R
\name{season_mov}
\alias{season_mov}
\title{Moving growing season division}
\usage{
season_mov(INPUT, options = list(r_min = 0), ..., years.run = NULL)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{options}{see details}

\item{...}{others to \code{\link[=season]{season()}}}

\item{years.run}{Numeric vector. Which years to run? If not specified, it is
all years.}
}
\description{
Moving growing season division
}
\section{options}{

\itemize{
\item \code{len_min}, \code{len_max}: minimum and maximum length (in the unit of days)
of growing season
\item \code{.lambda_vcurve}: Boolean. If the Whittaker's parameter lambda not provided,
whether to optimize lambda by V-curve theory? This parameter only works when
\code{lambda} not provided.
\item \code{maxExtendMonth}: Previous and subsequent \code{maxExtendMonth} data were added
for every year curve fitting.
}
}

\examples{
data("CA_NS6")
d <- CA_NS6

nptperyear <- 23
INPUT <- check_input(d$t, d$y, d$w,
    QC_flag = d$QC_flag,
    nptperyear = nptperyear, south = FALSE,
    maxgap = nptperyear / 4, alpha = 0.02, wmin = 0.2
)
# plot_input(INPUT)

wFUN <- "wTSM"
# all year as a whole
options = list(rFUN = smooth_wWHIT, wFUN = wFUN, lambda = 10)
brks <- season(INPUT, lambda = 10)
plot_season(INPUT, brks, d)

brks2 = opt_season(INPUT, options)
all.equal(brks2, brks)

c(d_fit, info_peak) \%<-\% rough_fitting(INPUT)
d_season = find_season.peaks(d_fit, info_peak)

c(t, ypred) \%<-\% d_fit[, .(t, ziter2)]
d_season = find_season.default(ypred, t)
all.equal(brks$dt, d_season)

# opt <- .options$season
# brks$fit - d_fit # function passed test

# curve fitting by year
brks_mov <- season_mov(INPUT,
    options = list(
        rFUN = "smooth_wWHIT", wFUN = wFUN,
        lambda = 10,
        r_min = 0.05, ypeak_min = 0.05,
        verbose = TRUE
    )
)
plot_season(INPUT, brks_mov)
}
\references{
\enumerate{
\item Kong, D., Zhang, Y., Wang, D., Chen, J., & Gu, X. (2020). Photoperiod
Explains the Asynchronization Between Vegetation Carbon Phenology and
Vegetation Greenness Phenology. Journal of Geophysical Research:
Biogeosciences, 125(8), e2020JG005636.
https://doi.org/10.1029/2020JG005636
\item Kong, D., Zhang, Y., Gu, X., & Wang, D. (2019). A robust method for
reconstructing global MODIS EVI time series on the Google Earth Engine.
ISPRS Journal of Photogrammetry and Remote Sensing, 155, 13-24.
}
}
