% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvefits.R
\name{curvefits}
\alias{curvefits}
\title{Fine Curve fitting}
\usage{
curvefits(INPUT, brks, wFUN = wTSM, iters = 2, wmin = 0.2,
  nextent = 2, maxExtendMonth = 3, minExtendMonth = 1, minT = 0,
  methods = c("AG", "Beck", "Elmore", "Gu", "Klos", "Zhang"),
  minPercValid = 0.2, print = TRUE, ...)
}
\arguments{
\item{INPUT}{A list object with the elements of 't', 'y', 'w', 'Tn' (option)
and 'ylu', returned by \code{check_input}.}

\item{brks}{A list object with the elements of 'fit' and 'dt', returned by
\code{season} or \code{season_mov}, which contains the growing season
dividing information.}

\item{wFUN}{weights updating function, can be one of \code{\link{wTSM}}, 
\code{\link{wChen}}, \code{\link{wBisquare}} and \code{\link{wSELF}}.}

\item{iters}{How many times curve fitting is implemented.}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{nextent}{Extend curve fitting window, until \code{nextent} good or
marginal element are found in previous and subsequent growing season.}

\item{maxExtendMonth}{Search good or marginal good values in previous and
subsequent `maxExtendMonth` period.}

\item{minExtendMonth}{Extending perid defined by \code{nextent} and
\code{maxExtendMonth} should be no shorter than \code{minExtendMonth}.
When all points of the input time-series are good value, then the extending
period will be too short. In that situation, we can't make sure the connection
between different growing seasons is smoothing.}

\item{minT}{Double, use night temperature Tn to define backgroud value.
Tn < minT is treated as ungrowing season.}

\item{methods}{Fine curve fitting methods, can be one or more of
\code{c('AG', 'Beck', 'Elmore', 'Gu', 'Klos', 'Zhang')}.}

\item{minPercValid}{If the percentage of good and marginal quality points is
less than \code{minPercValid}, curve fiting result is set to \code{NA}.}

\item{print}{Whether to print progress information?}

\item{...}{Other parameters will be ignore.}
}
\value{
fits Multiple phenofit object.
}
\description{
Fine Curve fitting for INPUT time-series.
}
\examples{
library(phenofit)
data("MOD13A1")

df <- tidy_MOD13.gee(MOD13A1$dt)
st <- MOD13A1$st

date_start <- as.Date('2013-01-01')
date_end   <- as.Date('2016-12-31')

sitename <- 'CA-NS6' # df$site[1]
d     <- df[site == sitename & (date >= date_start & date <= date_end), ]
sp    <- st[site == sitename, ]
south <- sp$lat < 0
nptperyear <- 23

# global parameter
IsPlot = TRUE
print  = FALSE
ypeak_min  = 0.05
wFUN = wTSM

# add one year in head and tail
dnew     <- add_HeadTail(d, south = south, nptperyear = nptperyear) 
INPUT    <- check_input(dnew$t, dnew$y, dnew$w, QC_flag = dnew$QC_flag,
     nptperyear = nptperyear, south = south, 
     maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
# Rough fitting and growing season dividing
brks2 <- season_mov(INPUT,
    rFUN = wWHIT, wFUN = wFUN,
    plotdat = d, IsPlot = IsPlot, print = FALSE, IsPlot.OnlyBad = FALSE)
# Fine fitting
fit <- curvefits(
    INPUT, brks2,
    methods = c("AG", "Beck", "Elmore", "Zhang"), #,"klos", "Gu"
    wFUN = wFUN,
    nextent = 2, maxExtendMonth = 2, minExtendMonth = 1, minPercValid = 0.2,
    print = TRUE, verbose = FALSE)
}
