% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_estimation_step}
\alias{add_estimation_step}
\title{add_estimation_step}
\usage{
add_estimation_step(model, method, idx = NULL, ...)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) estimation method to change to}

\item{idx}{(numeric (optional)) index of estimation step (starting from 0), default is NULL (adds step at the end)}

\item{...}{Arguments to pass to EstimationStep (such as interaction, evaluation)}
}
\value{
(Model) Pharmpy model object
}
\description{
Add estimation step

Adds estimation step for a model in a given index. Methods currently supported are:
FO, FOCE, ITS, LAPLACE, IMPMAP, IMP, SAEM
}
\examples{
\dontrun{
model <- load_example_model("pheno")
opts <- list('NITER'=1000, 'ISAMPLE'=100)
model <- add_estimation_step(model, 'IMP', tool_options=opts)
ests <- model$execution_steps
length(ests)
ests[2]
}
}
\seealso{
set_estimation_step

remove_estimation_step

append_estimation_step_options

add_parameter_uncertainty_step

remove_parameter_uncertainty_step

set_evaluation_step
}
