% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{update_inits}
\alias{update_inits}
\title{update_inits}
\usage{
update_inits(model, parameter_estimates, move_est_close_to_bounds = FALSE)
}
\arguments{
\item{model}{(Model) Pharmpy model to update initial estimates}

\item{parameter_estimates}{(array) Parameter estimates to update}

\item{move_est_close_to_bounds}{(logical) Move estimates that are close to bounds. If correlation >0.99 the correlation will
be set to 0.9, if variance is <0.001 the variance will be set to 0.01.}
}
\value{
(Model) Pharmpy model object
}
\description{
Update initial parameter estimate for a model

Updates initial estimates of population parameters for a model.
If the new initial estimates are out of bounds or NaN this function will raise.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
model$parameters$inits
model <- update_inits(model, results$parameter_estimates)
model$parameters$inits
}

}
