% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{transform_etas_tdist}
\alias{transform_etas_tdist}
\title{transform_etas_tdist}
\usage{
transform_etas_tdist(model, list_of_etas = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model to apply t distribution transformation to.}

\item{list_of_etas}{(array(str) or str (optional)) Name/names of etas to transform. If NULL, all etas will be transformed (default).}
}
\value{
(Model) Pharmpy model object
}
\description{
Applies a t-distribution transformation to selected etas

Initial estimate for degrees of freedom is 80 with bounds (3, 100).
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- transform_etas_tdist(model, c("ETA_1"))
model$statements$before_odes$full_expression("CL")
}
}
\seealso{
transform_etas_boxcox

transform_etas_john_draper
}
