% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mast.R
\name{mast}
\alias{mast}
\title{Maximum agreement subtree}
\usage{
mast(x, y, tree = TRUE, rooted = TRUE)
}
\arguments{
\item{x}{a tree, i.e. an object of class \code{phylo}.}

\item{y}{a tree, i.e. an object of class \code{phylo}.}

\item{tree}{a logicical, if TRUE returns a tree other wise the tip labels
of the the maximum agreement subtree.}

\item{rooted}{logical if TRUE treats trees as rooted otherwise unrooted.}
}
\value{
\code{mast} returns a vector of the tip labels in the MAST.
}
\description{
\code{mast} computes the maximum agreement subtree (MAST).
}
\details{
The code is derived from the code example in Valiente (2009).
The version for the unrooted trees is much slower.
}
\examples{
tree1 <- rtree(100)
tree2 <- rSPR(tree1, 5)
tips <- mast(tree1, tree2)

}
\references{
G. Valiente (2009). \emph{Combinatorial Pattern Matching Algorithms in Computational Biology using Perl and R}. Taylor & Francis/CRC Press
}
\seealso{
\code{\link{SPR.dist}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com} based on code of Gabriel Valiente
}
\keyword{cluster}
