% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{createFUNCTION}
\alias{createFUNCTION}
\title{Generate a postgreSQL CREATE FUNCTION statement, optionally execute the statement if con is not NULL.}
\usage{
createFUNCTION(
  name,
  args = NULL,
  or_replace = FALSE,
  returns = NULL,
  returns_table = NULL,
  language = "SQL",
  definition,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for postgreSQL CREATE FUNCTION.}

\item{args}{A named list, names are the argument names, values are strings with the argument data types.}

\item{or_replace}{TRUE/FALSE, if TRUE, adds "OR REPLACE" to postgreSQL CREATE FUNCTION statement.}

\item{returns}{A string, the "returns" parameter for postgreSQL CREATE FUNCTION.}

\item{returns_table}{A named list, names are the return table column names, values are strings with the return table data types.}

\item{language}{A string, the "language" parameter for postgreSQL CREATE FUNCTION.}

\item{definition}{A string, the "definition" parameter for postgreSQL CREATE FUNCTION.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL CREATE PROCEDURE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL CREATE FUNCTION statement, optionally execute the statement if con is not NULL.
}
\examples{
createFUNCTION(
name = "sample_add",
args = list(a = "INTEGER", b = "INTEGER"),
returns = "INT",
language = "plpgsql",
definition = "BEGIN RETURN sample_add.a + sample_add.b; END;"
)
}
