% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perumammals-data.R
\docType{data}
\name{peru_mammals_ecoregions}
\alias{peru_mammals_ecoregions}
\title{Mammal species by Peruvian ecoregion}
\format{
A tibble with one row per species–ecoregion combination and
3 variables:
\describe{
\item{pm_id}{Character. Internal species identifier, matching
\code{\link{peru_mammals}}.}
\item{scientific_name}{Character. Binomial scientific name
(\emph{Genus species}).}
\item{ecoregion_code}{Character. Abbreviation of the ecoregion where
the species occurs (e.g. \code{"YUN"}, \code{"SB"}, \code{"COS"}).
See \code{\link{peru_mammals_ecoregions_meta}} for code definitions.}
}
}
\source{
Pacheco et al. (2021).
}
\usage{
data("peru_mammals_ecoregions")
}
\description{
A long-format table linking each mammal species to the Peruvian ecoregions
where it occurs, based on Pacheco et al. (2021).
}
\details{
Each row corresponds to a single combination of species and ecoregion.
This dataset is derived from the \code{ecoregions} field of
\code{\link{peru_mammals}}.
}
\seealso{
\code{\link{peru_mammals}},
\code{\link{peru_mammals_ecoregions_meta}}
}
\keyword{datasets}
