% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tivi.R
\name{tivi}
\alias{tivi}
\title{Compute personal values from TIVI data}
\usage{
tivi(df, items = NULL, compute = "all", correction = TRUE, na.rm = TRUE)
}
\arguments{
\item{df}{A data frame containing the raw responses for the 10 TIVI items.
If "items" is not provided, it must have exactly 10 columns, and their order
must correspond to the TIVI items.}

\item{items}{An optional vector containing the names or indices of the columns
that correspond to the TIVI items. Must be exactly 10 items. If NULL,
the function assumes the items are the only columns given in the "df" parameter.}

\item{compute}{Character. Indicates which personal values scores to compute and return.
Possible values are "all" (default), "ten.values", "four.higher", "two.foci",
or "two.dynamics".}

\item{correction}{Logical. When TRUE, the scores are corrected for individual differences
in the use of the response scale. Default is TRUE.}

\item{na.rm}{Logical. When TRUE, NAs are ignored in calculations; when FALSE,
NAs are preserved and will affect calculations. Default is TRUE.}
}
\value{
A data frame with computed values. If both "df" and "items" parameters are
        provided, the returned data frame includes the original data with the calculations
        appended as new columns.
}
\description{
This function computes personal values scores and different higher-order
dimensions related to Schwartz's theoretical framework based on the 10 items
of the ultra-brief TIVI Questionnaire (Sandy et al., 2017).
By default, the function applies the recommended statistical adjustment
(individual MRAT centering) as suggested by the authors, to correct for
individual differences in response styles thus enhancing the interpretative
validity of the scores.
}
\note{
Developed by Giuseppe Corbelli, email: giuseppe.corbelli@uninettunouniversity.net,
      giuseppe.corbelli@uniroma1.it
}
\examples{
persval::tivi(df = data.frame(
tivi1 = c(3, 1, 4), tivi2 = c(2, 5, 3), tivi3 = c(1, 5, 2),
tivi4 = c(4, 3, 5), tivi5 = c(5, 2, 1), tivi6 = c(3, 4, 2), tivi7 = c(1, 2, 4),
tivi8 = c(3, 1, 5), tivi9 = c(2, 4, 1), tivi10 = c(5, 3, 2)
),
correction = TRUE,
compute = "all",
na.rm = TRUE)

}
