% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutes.R
\name{permu.test}
\alias{permu.test}
\title{Permutation tests for time series data.}
\usage{
permu.test(formula, data, subset = NULL, type = "anova",
  parallel = FALSE, progress = "text", ...)
}
\arguments{
\item{formula}{A formula of the following form: \code{outcome ~ predictors | timepoint variable}. Multivariate outcomes (e.g. 32 EEG electrodes) are supported; use \code{cbind(Fp1,Fp2,etc) ~ predictors | timepoint}.}

\item{data}{The dataset referencing these predictors.}

\item{subset}{If specified, will only analyze the specified subset of the data.}

\item{type}{One of \code{'anova'} or \code{'regression'}. The former runs an analysis of variance and returns F-values and p-values based on sums of squares. The latter runs a linear-regression analysis and returns t-values and p-values based on individual effects. When running ANOVA, it is advised to use orthogonal predictors, as type III sums of squares are used.}

\item{parallel}{Whether to parallelize the permutation testing using plyr's \code{parallel} option. Needs some additional set-up; see the plyr documentation.}

\item{progress}{A plyr \code{.progress} bar name, see the plyr documentation. Ignored if parallel=TRUE.}

\item{...}{Other arguments to be passed to \code{aovp}.}
}
\value{
A data frame.
}
\description{
Permutation tests for time series data.
}
\examples{
\donttest{
# EEG data example using the MMN dataset

# Run permutation tests on all electrodes and timepoints, reporting p-values for the three
# manipulated factors
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
               P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ dev*session | time,data=MMN)

# Run the tests in parallel on two CPU threads
# first, set up the parallel backend
library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
 P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ dev*session | time,data=MMN,parallel=TRUE)
stopCluster(cl)

# Plot the results
plot(perms)

# t-values instead of F-values
perms <- permu.test(cbind(Fp1,AF3,F7,F3,FC1,FC5,C3,CP1,CP5,P7,P3,Pz,PO3,O1,Oz,O2,PO4,P4,
               P8,CP6,CP2,C4,FC6,FC2,F4,F8,AF4,Fp2,Fz,Cz) ~ dev*session | time,data=MMN,
                                                                      type='regression')
}
\dontshow{
perms <- permu.test(Fp1 ~ dev*session | time,data=MMN[MMN$time > 200 & MMN$time < 205,])
perms <- permu.test(cbind(Fp1,Fp2) ~ dev*session | time,data=MMN[MMN$time > 200 & MMN$time < 205,])
perms <- permu.test(Fp1 ~ dev*session | time,data=MMN[MMN$time > 200 & MMN$time < 205,],type='regression')
perms <- permu.test(cbind(Fp1,Fp2) ~ dev*session | time,data=MMN[MMN$time > 200 & MMN$time < 205,],type='regression')
}
}
