% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceVector.R
\name{reduceVector}
\alias{reduceVector}
\title{Reduce a vector using the ordering process}
\usage{
reduceVector(x, verbosity = 0L)
}
\arguments{
\item{x}{a vector of numeric values}

\item{verbosity}{a natural number indicating the amount of output to print}
}
\value{
A list containing the original vector, the reduced vector, their
weights and the number of reductions performed. Use \code{\link[=names]{names()}} and \code{\link[=str]{str()}}
on the output for more details.
}
\description{
This function implements the ordering process described in
Chacko (1963) and Chacko (1966).
}
\examples{
reduceVector(c(10, 16, 14, 12, 18))
reduceVector(c(10, 8, 4, 2, 1))
reduceVector(chacko66_sec3)
reduceVector(chacko66_sec5)
reduceVector(chacko66_sec5, verbosity = 1)
}
\author{
Waldir Leoncio
}
