% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_header}
\alias{add_ui_header}
\title{Add UI elements to dashboard header section}
\usage{
add_ui_header(
  ui_elements = NULL,
  ui_position = "right",
  title = NULL,
  title_position = "center",
  left_menu = NULL,
  right_menu = NULL,
  border = TRUE,
  compact = FALSE,
  right_sidebar_icon = shiny::icon("bars"),
  fixed = FALSE,
  left_sidebar_icon = shiny::icon("th"),
  skin = "light",
  status = "white"
)
}
\arguments{
\item{ui_elements}{- It can be any UI element but mostly used for navbarMenu. NULL by default.
Check \code{?bs4Dash::navbarMenu()}}

\item{ui_position}{- Location of UI elements in the header. Must be either of 'center', 'left' or 'right'
Default value is 'right'.}

\item{title}{- Sets application title. If it is not NULL, it will override "title" value that is set in
\code{?periscope2::set_app_parameters()} (default = NULL)}

\item{title_position}{- Location of the title in the header. Must be either of 'center', 'left' or 'right'
Default value is 'Center'. If there are no UI elements, this param will be ignored.}

\item{left_menu}{- Left menu. bs4DropdownMenu object (or similar dropdown menu).
Check \code{?bs4Dash::bs4DropdownMenu()}}

\item{right_menu}{- Right menu. bs4DropdownMenu object (or similar dropdown menu).
Check \code{?bs4Dash::bs4DropdownMenu()}}

\item{border}{- Whether to separate the navbar and body by a border. TRUE by default}

\item{compact}{- Whether items should be compacted. FALSE by default}

\item{right_sidebar_icon}{- Right sidebar toggle icon}

\item{fixed}{- Whether to fix the navbar to the top. FALSE by default}

\item{left_sidebar_icon}{- Left sidebar toggle icon}

\item{skin}{- Sidebar skin. "dark" or "light"}

\item{status}{- Sidebar status. Check \code{?bs4Dash::bs4DashNavbar()} for list of valid values}
}
\value{
list of both shiny UI elements and named header properties
}
\description{
Builds application header with given configurations and elements. It is called within "ui_header.R".
These elements will be displayed in the header beside application title and application busy indicator.
}
\details{
User can configure UI elements, application title and the busy indicator positions as well using this method.

Check example application for detailed example
}
\section{Shiny Usage}{

Call this function from \code{program/ui_header.R} to set header parameters
}

\examples{
  library(shiny)
  library(bs4Dash)

  # Inside ui_header.R
  # Custom left UI menu
  left_menu <- tagList(dropdownMenu(badgeStatus = "info",
                                  type        = "notifications",
                                   notificationItem(inputId = "triggerAction2",
                                                    text    = "Error!",
                                                    status  = "danger")),
                      dropdownMenu(badgeStatus = "info",
                                   type        = "tasks",
                                   taskItem(inputId = "triggerAction3",
                                            text    = "My progress",
                                            color   = "orange",
                                            value   = 10)))

  # Custom right UI menu
  right_menu <- dropdownMenu(badgeStatus = "danger",
                          type        = "messages",
                          messageItem(inputId = "triggerAction1",
                                      message = "message 1",
                                      from    = "Divad Nojnarg",
                                      time    = "today",
                                      color   = "lime"))
  # -- Register Header Elements in the ORDER SHOWN in the UI
  add_ui_header(left_menu = left_menu, right_menu = right_menu)

}
\seealso{
\link[bs4Dash:bs4DashNavbar]{bs4Dash:bs4DashNavbar()}

\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
