% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{calcRec}
\alias{calcRec}
\title{Recombination frequencies computation}
\usage{
calcRec(input, ploidy, sparse = FALSE, ...)
}
\arguments{
\item{input}{Matrix of genotypes. Rows represent markers. 
Columns represent samples.}

\item{ploidy}{Ploidy level of the organism.}

\item{sparse}{Logical, if the matrix is a sparse matrix or not.}

\item{...}{arguments are forwarded to \code{pairwRF}.}
}
\value{
Matrix of pairwise recombination frequencies.
}
\description{
Calculate recombination frequencies for a whole matrix
}
\examples{
data(simTetra)
simTetraGen <- bases2genotypes(simTetra, ploidy = 4)
calcRec(simTetraGen, 4)
}

