% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumpAlleles.R
\name{lumpAlleles}
\alias{lumpAlleles}
\title{Allele lumping}
\usage{
lumpAlleles(
  x,
  markers = NULL,
  always = FALSE,
  special = TRUE,
  alleleLimit = Inf,
  verbose = FALSE
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{markers}{A vector of names or indices referring to markers attached to
\code{x}. (Default: All markers.)}

\item{always}{A logical. If TRUE, lumping is always attempted. By default
(FALSE) lumping is skipped for markers where no individuals, or all
individuals, are genotyped.}

\item{special}{A logical. If TRUE, special lumping procedures (depending on
the pedigree) will be attempted if the marker has a mutation model that is
not generally lumpable (in the Kemeny-Snell sense).}

\item{alleleLimit}{A positive number or \code{Inf} (default). If the mutation
model is not generally lumpable, and the allele count exceeds this limit,
switch to an \code{equal} model with the same rate and reapply lumping.}

\item{verbose}{A logical.}
}
\value{
An object similar to \code{x}, but whose attached markers have reduced
allele set.
}
\description{
Perform allele lumping (i.e., merging unobserved alleles) for all markers
attached to the input pedigree.
}
\examples{
x = nuclearPed() |> addMarker(geno = c(NA, NA, "1/1"), alleles = 1:5)

# Before lumping
afreq(x, 1)

# Lump
y = lumpAlleles(x, verbose = TRUE)
afreq(y, 1)

# With lumpable mutation model
x2 = setMutmod(x, model = "equal", rate = 0.1)
mutmod(x2, 1)

y2 = lumpAlleles(x2, verbose = TRUE)
mutmod(y2, 1)

# Mutation model requiring special lumping
x3 = setMutmod(x, model = "random", rate = 0.1, seed = 1)
mutmod(x3, 1)

# Lump
y3 = lumpAlleles(x3, verbose = TRUE)
mutmod(y3, 1)

stopifnot(likelihood(x) == likelihood(y),
          likelihood(x2) == likelihood(y2),
          likelihood(x3) == likelihood(y3))

}
