% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cow_mid_ddydisps}
\alias{cow_mid_ddydisps}
\title{Directed Dyadic Dispute-Year Data with No Duplicate Dyad-Years (CoW-MID, v. 5.0)}
\format{
A data frame with 10234 observations on the following 25 variables.
\describe{
\item{\code{dispnum}}{a numeric vector for the CoW-MID dispute number}
\item{\code{ccode1}}{a numeric vector for the focal state in the dyad}
\item{\code{ccode2}}{a numeric vector for the target state in the dyad}
\item{\code{year}}{a numeric vector for the dispute-year}
\item{\code{cowmidongoing}}{a numeric vector for whether there was a dispute ongoing in that year}
\item{\code{cowmidonset}}{a numeric vector for whether it was the onset of a new dispute (or new participant-entry into a recurring dispute)}
\item{\code{sidea1}}{is \code{ccode1} on side A of the dispute?}
\item{\code{sidea2}}{is \code{ccode2} on side A of the dispute?}
\item{\code{fatality1}}{a numeric vector for the overall fatality level of \code{ccode1} in the dispute}
\item{\code{fatality2}}{a numeric vector for the overall fatality level of \code{ccode2} in the dispute}
\item{\code{fatalpre1}}{a numeric vector for the known fatalities (with precision) for \code{ccode1} in the dispute}
\item{\code{fatalpre2}}{a numeric vector for the known fatalities (with precision) for \code{ccode2} in the dispute}
\item{\code{hiact1}}{a numeric vector for the highest action of \code{ccode1} in the dispute}
\item{\code{hiact2}}{a numeric vector for the highest action of \code{ccode2} in the dispute}
\item{\code{hostlev1}}{a numeric vector for the hostility level of \code{ccode1} in the dispute}
\item{\code{hostlev2}}{a numeric vector for the hostility level of \code{ccode2} in the dispute}
\item{\code{orig1}}{is \code{ccode1} an originator of the dispute?}
\item{\code{orig2}}{is \code{ccode2} an originator of the dispute?}
\item{\code{fatality}}{a numeric vector for the fatality level of the dispute}
\item{\code{hostlev}}{a numeric vector for the hostility level of the MID}
\item{\code{mindur}}{a numeric vector for the minimum duration of the MID}
\item{\code{maxdur}}{a numeric vector for the maximum duration of the MID}
 \item{\code{recip}}{a numeric vector for whether a MID was reciprocated}
 \item{\code{stmon}}{a numeric vector for the start month of the MID}
}
}
\usage{
cow_mid_ddydisps
}
\description{
These are directed dyadic dispute year data derived from the Correlates of War (CoW) Militarized Interstate
 Dispute (MID) project. Data are from version 5.0. These were whittled to where there is no duplicate dyad-years.
 Its primary aim here is merging into a dyad-year data frame.
}
\details{
The process of creating these is described at one of the references below. Importantly, these data are somewhat
"naive." That is: they won't tell you, for example, that Brazil and Japan never directly fought each other during World War II.
Instead, it will tell you that there were two years of overlap for the two on different sides of the conflict and that the highest
action for both was a war. The data are thus similar to what the \code{EUGene} program would create for users back in the day. Use these
data with that limitation in mind.
}
\references{
Miller, Steven V. 2021. "How to (Meticulously) Convert Participant-Level Dispute Data to Dyadic Dispute-Year Data in R."
URL: \url{http://svmiller.com/blog/2021/05/convert-cow-mid-data-to-dispute-year/}

Palmer, Glenn, and Roseanne W. McManus and Vito D'Orazio and Michael R. Kenwick and Mikaela Karstens
and Chase Bloch and Nick Dietrich and Kayla Kahn and Kellan Ritter and Michael J. Soules. 2021.
"The MID5 Dataset, 2011–2014: Procedures, coding rules, and description" \emph{Conflict Management and Peace Science}.
}
\keyword{datasets}
