% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{pdf_render_page}
\alias{pdf_render_page}
\alias{render}
\alias{pdf_convert}
\alias{poppler_config}
\title{Render / Convert PDF}
\usage{
pdf_render_page(pdf, page = 1, dpi = 72, numeric = FALSE,
  antialias = TRUE, opw = "", upw = "")

pdf_convert(pdf, format = "png", pages = NULL, filenames = NULL,
  dpi = 72, antialias = TRUE, opw = "", upw = "", verbose = TRUE)

poppler_config()
}
\arguments{
\item{pdf}{file path or raw vector with pdf data}

\item{page}{which page to render}

\item{dpi}{resolution (dots per inch) to render}

\item{numeric}{convert raw output to (0-1) real values}

\item{antialias}{enable antialiasing. Must be \code{"text"} or \code{"draw"} or \code{TRUE} (both)
or \code{FALSE} (neither).}

\item{opw}{owner password}

\item{upw}{user password}

\item{format}{string with output format such as \code{"png"} or \code{"jpeg"}. Must be equal
to one of \code{poppler_config()$supported_image_formats}.}

\item{pages}{vector with one-based page numbers to render. \code{NULL} means all pages.}

\item{filenames}{vector of equal length to \code{pages} with output filenames. May also be
a format string which is expanded using \code{pages} and \code{format} respectively.}

\item{verbose}{print some progress info to stdout}
}
\description{
High quality conversion of pdf page(s) to png, jpeg or tiff format, or render into a
raw bitmap array for further processing in R.
}
\examples{
# Rendering should be supported on all platforms now
if(poppler_config()$can_render){

# convert few pages to png
file.copy(file.path(Sys.getenv("R_DOC_DIR"), "NEWS.pdf"), "news.pdf")
pdf_convert("news.pdf", pages = 1:3)

# render into raw bitmap
bitmap <- pdf_render_page("news.pdf")

# save to bitmap formats
png::writePNG(bitmap, "page.png")
jpeg::writeJPEG(bitmap, "page.jpeg")
webp::write_webp(bitmap, "page.webp")

# Higher quality
bitmap <- pdf_render_page("news.pdf", page = 1, dpi = 300)
png::writePNG(bitmap, "page.png")

# slightly more efficient
bitmap_raw <- pdf_render_page("news.pdf", numeric = FALSE)
webp::write_webp(bitmap_raw, "page.webp")
}
}
\seealso{
Other pdftools: \code{\link{pdf_info}}
}
