pdcor.test <- function (x, y, z, type = 1, R = 500) {

  if ( is.vector(x) ) {
    n <- length(x)
    a1 <- dcov::dcor(x, y, type = "U")
    a2 <- dcov::dcor(x, z, type = "U")
    a3 <- dcov::dcor(y, z, type = "U")
    up <- a1 - a2 * a3
    down <- sqrt(1 - a2^2) * sqrt(1 - a3^2)
    stat <- up/down
    if ( type == 1 ) {
      pstat <- numeric(R)
      for ( i in 1:R ) {
        id <- Rfast2::Sample.int(n, n)
        a1 <- dcov::dcor(x[id], y, type = "U")
        a2 <- dcov::dcor(x[id], z, type = "U")
        up <- a1 - a2 * a3
        down <- sqrt(1 - a2^2) * sqrt(1 - a3^2)
        pstat[i] <- up/down
      }
    } else {
      x <- replicate( R, Rfast2::Sample(x, n) )
      a1 <- dcov::mdcor(y, x, type = 'U')
      a2 <- dcov::mdcor(z, x, type = 'U')
      up <- a1 - a2 * a3
      down <- sqrt(1 - a2^2) * sqrt(1 - a3^2)
      pstat <- up / down
    }

  } else {
    a1 <- Rfast::dcor(x, y, bc = TRUE)$dcor
    a2 <- Rfast::dcor(x, z, bc = TRUE)$dcor
    a3 <- Rfast::dcor(y, z, bc = TRUE)$dcor
    up <- a1 - a2 * a3
    down <- sqrt(1 - a2^2) * sqrt(1 - a3^2)
    stat <- up/down
    pstat <- numeric(R)
    for ( i in 1:R ) {
      id <- Rfast2::Sample.int(n, n)
      a1 <- Rfast::dcor(x[id, ], y, bc = TRUE)$dcor
      a2 <- Rfast::dcor(x[id, ], z, bc = TRUE)$dcor
      up <- a1 - a2 * a3
      down <- sqrt(1 - a2^2) * sqrt(1 - a3^2)
      pstat[i] <- up/down
    }
  }

  res <- c( stat, ( sum( pstat > stat ) + 1 ) / (R + 1), pchisq(1 + n * stat, 1, lower.tail = FALSE) )
  names(res) <- c("udcor", "permutation p-value", "asymptotic p-value")
  res
}






