% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexSurvPlot.R
\name{flexsurvregPlot}
\alias{flexsurvregPlot}
\title{Function to visualize \code{flexsurv::flexsurvreg} models fit by \code{fitGrowth}.}
\usage{
flexsurvregPlot(
  fit,
  form,
  groups = NULL,
  df = NULL,
  timeRange = NULL,
  facetGroups = TRUE,
  groupFill = FALSE,
  virMaps = c("plasma")
)
}
\arguments{
\item{fit}{A model fit returned by \code{fitGrowth} with type="nls".}

\item{form}{A formula similar to that in \code{growthSS} inputs
(or the \code{pcvrForm} part of the output) specifying the outcome,
predictor, and grouping structure of the data as \code{outcome ~ predictor|individual/group}.
If the individual and group are specified then the observed growth lines are plotted.}

\item{groups}{An optional set of groups to keep in the plot.
Defaults to NULL in which case all groups in the model are plotted.}

\item{df}{A dataframe to use in plotting observed growth curves on top of the model.
This must be supplied for nls models.}

\item{timeRange}{Ignored, included for compatibility with other plotting functions.}

\item{facetGroups}{logical, should groups be separated in facets? Defaults to TRUE.}

\item{groupFill}{logical, should groups have different colors? Defaults to FALSE. If TRUE then
viridis colormaps are used in the order of virMaps}

\item{virMaps}{order of viridis maps to use. Will be recycled to necessary length.
Defaults to "plasma", but will generally be informed by growthPlot's default.}
}
\value{
Returns a ggplot showing an survival model's survival function.
}
\description{
Models fit using \link{growthSS} inputs by \link{fitGrowth}
(and similar models made through other means) can be visualized easily using this function.
This will generally be called by \code{growthPlot}.
}
\examples{

df <- growthSim("logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- growthSS(model = "survival weibull", form = y > 100 ~ time | id / group,
               df = df, type = "flexsurv")
fit <- fitGrowth(ss)
flexsurvregPlot(fit, form = ss$pcvrForm, df = ss$df, groups = "a")
flexsurvregPlot(fit, form = ss$pcvrForm, df = ss$df,
  facetGroups = FALSE, groupFill = TRUE)

}
\keyword{survival}
