% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{igraph_translator}
\alias{igraph_translator}
\title{Translate text of igraph}
\usage{
igraph_translator(
  ig,
  from = "en",
  to = "zh",
  which = c("vertex", "edge", "all")[1],
  verbose = TRUE
)
}
\arguments{
\item{ig}{igraph object to be translated}

\item{from}{source language}

\item{to}{target language}

\item{which}{vertex, edge, or all}

\item{verbose}{verbose}
}
\value{
igraph object
}
\description{
Translate text of igraph
}
\examples{
\dontrun{
library(igraph)
ig <- make_graph(c("happy", "sad", "sad", "angry", "sad", "worried"))
plot(ig)
ig2 <- igraph_translator(ig)
font_file <- "/System/Library/Fonts/Supplemental/Songti.ttc"
sysfonts::font_add("Songti", font_file)
plot(ig2, vertex.label.family = "Songti")
}
}
