% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_models.R
\name{calculate_lm}
\alias{calculate_lm}
\title{Calculate a linear model using PCSS}
\usage{
calculate_lm(
  means,
  covs,
  n,
  add_intercept = FALSE,
  keep_pcss = FALSE,
  terms = NULL
)
}
\arguments{
\item{means}{a vector of means of all model predictors and the response with
the last element the response mean.}

\item{covs}{a matrix of the covariance of all model predictors and the
response with the order of rows/columns corresponding to the order of
\code{means}.}

\item{n}{sample size}

\item{add_intercept}{logical. If \code{TRUE} adds an intercept to the model.}

\item{keep_pcss}{logical. If \code{TRUE}, returns \code{means} and 
\code{covs}.}

\item{terms}{terms}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{calculate_lm} describes the linear model of the last listed variable
in \code{means} and \code{covs} as a function of all other variables in
\code{means} and \code{covs}.
}
\references{
{

  \insertRef{wolf_using_2021}{pcsstools}
  
  \insertRef{wolf_computationally_2020}{pcsstools}
  
  \insertRef{gasdaska_leveraging_2019}{pcsstools}

}
}
