% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDegradation.R
\name{calculateDegradation}
\alias{calculateDegradation}
\title{Calculate Degradation Parameter}
\usage{
calculateDegradation(conc, size, debug = FALSE)
}
\arguments{
\item{conc}{numeric vector with measured concentrations.}

\item{size}{numeric vector with number of base pairs for the targets.}

\item{debug}{logical to print debug information.}
}
\value{
numeric calculated degradation parameter.
}
\description{
Calculate the degradation parameter (probability of degradation per base pair).
}
\details{
Calculates the degradation parameter given the concentrations measured with 
two targets of different size.
NB! The concentration from the shorter fragment must be given first with the
corresponding target size first in the size vector.
}
\examples{
# The DNA concentration for a degraded sample measured with probe sizes 70 and 220 bp
# was 85 and 0.5 ng/ul respectively.
# Calulate the degradation parameter:
calculateDegradation(conc=c(85,0.5), size=c(70,220))

}

