% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{arcsCSmid.int}
\alias{arcsCSmid.int}
\title{The arcs of Central Similarity Proximity Catch Digraph (CS-PCD) for 1D data - middle intervals case}
\usage{
arcsCSmid.int(Xp, Yp, t, c = 0.5)
}
\arguments{
\item{Xp}{A set or \code{vector} of 1D points which constitute the vertices of the CS-PCD.}

\item{Yp}{A set or \code{vector} of 1D points which constitute the end points of the intervals.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, they are expansion and centrality parameters.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the intervalization based on \code{Yp} points.}
\item{tess.name}{Name of data set used in tessellation, it is \code{Yp} for this function}
\item{vertices}{Vertices of the digraph, i.e., \code{Xp} points}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of CS-PCD for 1D data in the middle intervals}
\item{E}{Heads (or arrow ends) of the arcs of CS-PCD for 1D data in the middle intervals}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) for 1D data set \code{Xp} as the vertices
of CS-PCD and related parameters and the quantities of the digraph.

For this function, CS proximity regions are constructed with respect to the intervals
based on \code{Yp} points with expansion parameter \eqn{t>0} and centrality parameter \eqn{c \in (0,1)}. That is, for this
function, arcs may exist for points only inside the intervals.
It also provides various descriptions and quantities about the arcs of the CS-PCD
such as number of arcs, arc density, etc.

Vertex regions are based on center \eqn{M_c} of each middle interval.

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
t<-1.5
c<-.4
a<-0; b<-10

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

arcsCSmid.int(Xp,Yp,t,c)
arcsCSmid.int(Xp,Yp+10,t,c)

Arcs<-arcsCSmid.int(Xp,Yp,t,c)
Arcs
summary(Arcs)
plot(Arcs)

S<-Arcs$S
E<-Arcs$E

jit<-.1
yjit<-runif(nx,-jit,jit)

Xlim<-range(Xp,Yp)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),
main="arcs of CS-PCD whose vertices (jittered along y-axis)\n in middle intervals ",
xlab=" ", ylab=" ", xlim=Xlim+xd*c(-.05,.05),ylim=3*c(-jit,jit),pch=".")
abline(h=0,lty=1)
points(Xp, yjit,pch=".",cex=3)
abline(v=Yp,lty=2)
arrows(S, yjit, E, yjit, length = .05, col= 4)

t<-.5
c<-.4
a<-0; b<-10;
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

arcsCSmid.int(Xp,Yp,t,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{arcsPEend.int}}, \code{\link{arcsPE1D}}, \code{\link{arcsCSmid.int}},
 \code{\link{arcsCSend.int}} and \code{\link{arcsCS1D}}
}
\author{
Elvan Ceyhan
}
