% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{IncMatPEint}
\alias{IncMatPEint}
\title{Incidence matrix for Proportional-Edge Proximity Catch Digraphs (PE-PCDs)
for 1D data - one interval case}
\usage{
IncMatPEint(Xp, int, r, c = 0.5)
}
\arguments{
\item{Xp}{a set of 1D points which constitutes the vertices of the digraph.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 1D data set, \code{Xp},
and \code{int} determines the end points of the intervals (in the one interval case)
}
\description{
Returns the incidence matrix for the PE-PCD for a given 1D numerical data set, \code{Xp},
as the vertices of the digraph and \code{int} determines the end points of the interval (in the one interval case).
Loops are allowed, so the diagonal entries are all equal to 1.

PE proximity region is constructed
with an expansion parameter \eqn{r \ge 1} and a centrality parameter \eqn{c \in (0,1)}.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

xf<-(int[2]-int[1])*.1

set.seed(123)

n<-10
Xp<-runif(n,a-xf,b+xf)

IM<-IncMatPEint(Xp,int,r,c)
IM

dom.greedy(IM)
IndUBdom(IM,6)
dom.exact(IM)

IncMatPEint(Xp,int+10,r,c)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatCSint}}, \code{\link{IncMatPE1D}}, \code{\link{IncMatPEtri}}, and \code{\link{IncMatPE}}
}
\author{
Elvan Ceyhan
}
