% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{PEdom.tetra}
\alias{PEdom.tetra}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) - one tetrahedron case}
\usage{
PEdom.tetra(Xp, th, r, M = "CM")
}
\arguments{
\item{Xp}{A set of 3D points which constitute the vertices of the digraph.}

\item{th}{Four 3D points, stacked row-wise, each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}
}
\value{
A \code{list} with two elements
\item{dom.num}{Domination number of PE-PCD with vertex set = \code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
\item{mds}{A minimum dominating set of PE-PCD with vertex set = \code{Xp} and expansion parameter \eqn{r \ge 1} and center \code{M}}
}
\description{
Returns the domination number of PE-PCD whose vertices are the data points in \code{Xp}.

PE proximity region is defined with respect to the tetrahedron \code{th} with expansion parameter \eqn{r \ge 1} and
vertex regions are based on the center \code{M} which is circumcenter (\code{"CC"}) or center of mass (\code{"CM"}) of \code{th}
with default=\code{"CM"}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-10  #try also n<-20

dat<-runif.tetra(n,tetra)$g

M<-"CM"  #try also M<-"CC"
r<-1.25

PEdom.tetra(dat,tetra,r,M)

PEdom.tetra(rbind(dat,c(5,5,5)),tetra,r,M)

P1<-c(.5,.5,.5)
PEdom.tetra(P1,tetra,r,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PEdomtri}}
}
\author{
Elvan Ceyhan
}
