% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{seg.tri.supp}
\alias{seg.tri.supp}
\title{The auxiliary triangle to define the support of type I segregation}
\usage{
seg.tri.supp(delta, tri)
}
\arguments{
\item{delta}{a positive real number between 0 and 1}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}
}
\value{
the vertices of the triangle (stacked row-wise) whose intersection with a general triangle
gives the support for type I segregation for the given \code{delta}
}
\description{
Returns the triangle whose intersection with a general triangle gives the support for
type I segregation given the \code{delta} (i.e., \eqn{\delta 100} \% area of a triangle around the vertices is chopped off).
See the plot in the examples.

Caveat: the vertices of this triangle may be outside the triangle, \code{tri}, depending on the value of \code{delta}
(i.e., for small values of \code{delta})
}
\examples{
\donttest{
#the standard equilateral triangle
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
delta<-.3  #try also .5,.75,.85
seg.tri.supp(delta,Te)

Tseg<-seg.tri.supp(delta,Te)

Xlim<-range(Te[,1],Tseg[,1])
Ylim<-range(Te[,2],Tseg[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

oldpar <- par(mfrow = c(1,2))
par(pty="s")
plot(Te,pch=".",xlab="",ylab="",
main="segregation support is the intersection\n of these two triangles"
     ,axes=T,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
polygon(Tseg,lty=2)

txt<-rbind(Te,Tseg)
xc<-txt[,1]+c(-.03,.03,.03,.05,.04,-.04)
yc<-txt[,2]+c(.02,.02,.04,-.03,0,0)
txt.str<-c("A","B","C","T1","T2","T3")
text(xc,yc,txt.str)
par(oldpar)

#for a general triangle
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
delta<-.3  #try also .5,.75,.85
Tseg<-seg.tri.supp(delta,Tr)

Xlim<-range(Tr[,1],Tseg[,1])
Ylim<-range(Tr[,2],Tseg[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

oldpar <- par(mfrow = c(1,2))
par(pty="s")
plot(Tr,pch=".",xlab="",ylab="",
main="segregation support is the intersection\n of these two triangles"
     ,axes=T,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
polygon(Tseg,lty=2)

txt<-rbind(Tr,Tseg)
xc<-txt[,1]+c(-.03,.03,.03,.06,.04,-.04)
yc<-txt[,2]+c(.02,.02,.04,-.03,0,0)
txt.str<-c("A","B","C","T1","T2","T3")
text(xc,yc,txt.str)
par(oldpar)

dat.fr<-data.frame(a=Tr)
seg.tri.supp(delta,dat.fr)
}

}
\seealso{
\code{\link{rsegTe}} and \code{\link{rsegMT}}
}
