% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{corpca}
\alias{corpca}
\title{Principal Component Analysis based on the correlation matrix}
\usage{
corpca(data, K, scale = TRUE)
}
\arguments{
\item{data}{a data matrix or a data frame.}

\item{K}{an integer specifying the number of principal components that are retained.}

\item{scale}{a logical value indicating whether the data has to be scaled.}
}
\description{
\code{corpca} is an auxiliary function that performs principal components analysis on a dataset. It returns an object \code{x}
which contains the loadings, the scores and the singular values of the \code{K} first principal components.
It handles missing values in a dataset and actually computes the eigen elements of the \code{n x n}
covariance matrix, where \code{n} is the number of individuals.
}
\examples{
data <- read4pcadapt("geno3pops",option="example")
x <- corpca(data,K=3)
}
\keyword{internal}

